package gov.va.med.mhv.admin.repository;

import gov.va.med.mhv.admin.model.EmployeeOrgRole;
import gov.va.med.mhv.admin.model.OrgTypeRole;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmployeeOrgRoleRepository extends JpaRepository<EmployeeOrgRole, Long>{
	
	@Query("select empOrgRole from EmployeeOrgRole as empOrgRole where empOrgRole.employee.id = :employeeId "
    			 			+"order by empOrgRole.active desc, empOrgRole.role.name asc")
	public List<EmployeeOrgRole> getEmployeeOrgRolesAssignedToEmployee(@Param ("employeeId") Long employeeId);
	
	@Query("select empOrgRole from EmployeeOrgRole as empOrgRole where lower(empOrgRole.employee.userName) = :userName"
 			+" and empOrgRole.active = 1")
	public List<EmployeeOrgRole> getEmployeeOrgRolesAssignedToEmployeeByName(@Param ("userName") String userName);
	
	@Query("from EmployeeOrgRole as empOrgRole" 
							+" where empOrgRole.organization.id = :organizationId" 
							+" and empOrgRole.role.id = :roleId"  
							+" and empOrgRole.active = 1")
	public List<EmployeeOrgRole> getActiveRoleAssignments(@Param ("organizationId") Long organizationId,@Param ("roleId") Long roleId);
	
	/* 
  		Per requirements, employee can manage role assignments for:
  		a) non admin roles at an organization for which they are themselves an admin
  		b) admin roles for child organizations of an organization for which they are themselves an admin
  	
  		In this somewhat complex query below...
  		1) the where clause is fulling requirement A from above
  		2) the org clause is fulling requirement B from above
   	*/
	
	@Query("from EmployeeOrgRole as empOrgRole where empOrgRole.id in("
								+" select distinct empOrgRoleToManage.id" 
			    				+" from EmployeeOrgRole as empOrgRoleToManage,"  
								+" EmployeeOrgRole as empOrgRole"  
								+" where (empOrgRoleToManage.organization.id = empOrgRole.organization.id"  
								+" and empOrgRole.active = 1"  
								+" and empOrgRole.role.securityAdmin = 1"   
								+" and empOrgRoleToManage.role.securityAdmin = 0"  
								+" and empOrgRole.employee.id =:employeeId)"     				  
								+" or    (empOrgRoleToManage.organization.parentOrganization = empOrgRole.organization.id"  
								+" and empOrgRole.active = 1"   
								+" and empOrgRole.role.securityAdmin = 1"   
								+" and empOrgRoleToManage.role.securityAdmin = 1"  
								+" and empOrgRole.employee.id =:employeeId)" 
								+" ) order by empOrgRole.active desc, empOrgRole.role.name asc,"  
							    +" empOrgRole.employee.lastName asc, empOrgRole.employee.firstName asc")
	public List<EmployeeOrgRole> getEmployeeOrgRolesEmployeeCanManage(@Param ("employeeId") Long employeeId);
	
	@Query("select distinct orgTypeRole.role from OrgTypeRole orgTypeRole," 
			+" EmployeeOrgRole as empOrgRole,"
			+" Org org" 
			+" where (empOrgRole.organization.id=:organizationId" 
				+" and empOrgRole.role.securityAdmin=1" 
				+" and empOrgRole.employee.id=:employeeId" 
				+" and empOrgRole.active=1" 
				+" and orgTypeRole.typeOfOrganization=empOrgRole.organization.typeOfOrganization"  
				+" and orgTypeRole.role.securityAdmin=0)"
			+" or    (org.id=:organizationId"
				+" and empOrgRole.organization.id=org.parentOrganization"
				+" and empOrgRole.role.securityAdmin=1"  
				+" and empOrgRole.employee.id=:employeeId" 
				+" and empOrgRole.active=1" 
				+" and orgTypeRole.typeOfOrganization=org.typeOfOrganization" 
				+" and orgTypeRole.role.securityAdmin=1)")
public List<OrgTypeRole> getRolesAtOrganizationEmployeeCanManage(@Param ("employeeId") Long employeeId,@Param ("organizationId") Long organizationId);

}
